﻿using UnityEngine;
using System.Linq;
using System.Collections;
using System.Collections.Generic;
using Verse;
using Verse.AI.Group;

namespace RimWorld.BaseGen
{

public class SymbolResolver_AncientTemple : SymbolResolver
{
	private const float					MechanoidsChance		= 0.5f;
	private static readonly IntRange	MechanoidCountRange		= new IntRange(1, 5);
	private const float					ArtifactsChance			= 0.9f;
	private const float					LuciferiumChance		= 0.9f;
	private static readonly IntRange	ArtifactsCountRange		= new IntRange(1, 3);
	private const float					HivesChance				= 0.45f; // if no mechanoids
	private static readonly IntRange	HivesCountRange			= new IntRange(1, 2);
	private static readonly IntRange	LuciferiumCountRange	= new IntRange(5, 20);

	public override void Resolve(ResolveParams rp)
	{
		//Put Luciferium inside
		if( Rand.Chance(LuciferiumChance) )
		{
			var luciferiumParams = rp;
			luciferiumParams.singleThingDef = ThingDefOf.Luciferium;
			luciferiumParams.singleThingStackCount = rp.singleThingStackCount ?? LuciferiumCountRange.RandomInRange;

			BaseGen.symbolStack.Push("thing", luciferiumParams);
		}

		//Put artifacts inside
		if( Rand.Chance(ArtifactsChance) )
		{
			int artifactsCount = ArtifactsCountRange.RandomInRange;

			for( int i = 0; i < artifactsCount; i++ )
			{
				var artifactParams = rp;
				artifactParams.singleThingDef = DefDatabase<ThingDef>.AllDefs.Where(x => x.HasComp(typeof(CompUseEffect_Artifact))).RandomElement();

				BaseGen.symbolStack.Push("thing", artifactParams);
			}
		}

		//Put mechanoids inside
		if( Rand.Chance(MechanoidsChance) )
		{
			var randomMechanoidGroupParams = rp;
			randomMechanoidGroupParams.mechanoidsCount = rp.mechanoidsCount ?? MechanoidCountRange.RandomInRange;

			BaseGen.symbolStack.Push("randomMechanoidGroup", randomMechanoidGroupParams);
		}
		else if( Rand.Chance(HivesChance) ) //Put insect hives inside
		{
			var hivesParams = rp;
			hivesParams.hivesCount = rp.hivesCount ?? HivesCountRange.RandomInRange;

			BaseGen.symbolStack.Push("hives", hivesParams);
		}

		//Ancient shrines
		{
			int entranceHeight = rp.ancientTempleEntranceHeight ?? 0;

			var ancientShrinesGroupParams = rp;
			ancientShrinesGroupParams.rect = rp.rect.ContractedBy(1);
			ancientShrinesGroupParams.rect.minZ += entranceHeight;

			BaseGen.symbolStack.Push("ancientShrinesGroup", ancientShrinesGroupParams);
		}

		//Empty room
		{
			var emptyRoomParams = rp;
			emptyRoomParams.wallStuff = rp.wallStuff ?? BaseGenUtility.RandomCheapWallStuff(rp.faction, notVeryFlammable: true);
			emptyRoomParams.clearEdificeOnly = rp.clearEdificeOnly ?? true; // this leaves the rock chunks inside the room;

			BaseGen.symbolStack.Push("emptyRoom", emptyRoomParams);
		}
	}
}

}